Option Explicit On 
Imports System
Imports System.IO
Imports System.Math
Imports System.Drawing.Drawing2D

Public Class Form1
    Inherits System.Windows.Forms.Form
    Dim stateMapLoaded, nodeClickingMode As Boolean
    Dim screenX() As Integer
    Dim screenY() As Integer
    Dim iNodeClicked As Integer   ' the previously clicked node index
#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem8 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem10 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem11 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem12 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem14 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem16 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem17 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem18 As System.Windows.Forms.MenuItem
    Friend WithEvents mFExit As System.Windows.Forms.MenuItem
    Friend WithEvents TabPage1 As System.Windows.Forms.TabPage
    Friend WithEvents MenuItem9 As System.Windows.Forms.MenuItem
    Friend WithEvents StatusBar1 As System.Windows.Forms.StatusBar
    Friend WithEvents ToolBar1 As System.Windows.Forms.ToolBar
    Friend WithEvents TreeView1 As System.Windows.Forms.TreeView
    Friend WithEvents tbbSave As System.Windows.Forms.ToolBarButton
    Friend WithEvents ImageList1 As System.Windows.Forms.ImageList
    Friend WithEvents tbbNew As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbOpenJob As System.Windows.Forms.ToolBarButton
    Friend WithEvents ttbOpenMap As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbPathCalc As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbHelp As System.Windows.Forms.ToolBarButton
    Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem13 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem15 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem19 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem20 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem21 As System.Windows.Forms.MenuItem
    Friend WithEvents Panel2 As System.Windows.Forms.Panel
    Friend WithEvents MenuItem22 As System.Windows.Forms.MenuItem
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Public WithEvents MapTab As System.Windows.Forms.TabControl
    Friend WithEvents Panel1 As System.Windows.Forms.PictureBox
    Friend WithEvents btnSelectPathManually As System.Windows.Forms.Button
    Friend WithEvents txtPathNodeDisp As System.Windows.Forms.TextBox
    Friend WithEvents btnBack As System.Windows.Forms.Button
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents txtActDisp As System.Windows.Forms.TextBox
    Friend WithEvents lblNodes As System.Windows.Forms.Label
    Friend WithEvents lblTurns As System.Windows.Forms.Label
    Friend WithEvents tbbUploadProgram As System.Windows.Forms.ToolBarButton
    Friend WithEvents tbbUploadFirmware As System.Windows.Forms.ToolBarButton
    Friend WithEvents mItemManualPathSel As System.Windows.Forms.MenuItem
    Friend WithEvents mItemBack As System.Windows.Forms.MenuItem
    Friend WithEvents mItemClearPath As System.Windows.Forms.MenuItem
    Friend WithEvents mItemOpenMap As System.Windows.Forms.MenuItem
    Friend WithEvents mItemSavePath As System.Windows.Forms.MenuItem
    Friend WithEvents mItemUploadProg As System.Windows.Forms.MenuItem
    Friend WithEvents ttbUploadCalibration As System.Windows.Forms.ToolBarButton
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim configurationAppSettings As System.Configuration.AppSettingsReader = New System.Configuration.AppSettingsReader
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.MenuItem1 = New System.Windows.Forms.MenuItem
        Me.MenuItem5 = New System.Windows.Forms.MenuItem
        Me.MenuItem7 = New System.Windows.Forms.MenuItem
        Me.MenuItem6 = New System.Windows.Forms.MenuItem
        Me.MenuItem8 = New System.Windows.Forms.MenuItem
        Me.MenuItem10 = New System.Windows.Forms.MenuItem
        Me.MenuItem9 = New System.Windows.Forms.MenuItem
        Me.MenuItem11 = New System.Windows.Forms.MenuItem
        Me.MenuItem13 = New System.Windows.Forms.MenuItem
        Me.MenuItem15 = New System.Windows.Forms.MenuItem
        Me.MenuItem12 = New System.Windows.Forms.MenuItem
        Me.MenuItem22 = New System.Windows.Forms.MenuItem
        Me.mFExit = New System.Windows.Forms.MenuItem
        Me.MenuItem19 = New System.Windows.Forms.MenuItem
        Me.MenuItem20 = New System.Windows.Forms.MenuItem
        Me.MenuItem21 = New System.Windows.Forms.MenuItem
        Me.MenuItem2 = New System.Windows.Forms.MenuItem
        Me.MenuItem3 = New System.Windows.Forms.MenuItem
        Me.MenuItem4 = New System.Windows.Forms.MenuItem
        Me.mItemManualPathSel = New System.Windows.Forms.MenuItem
        Me.mItemBack = New System.Windows.Forms.MenuItem
        Me.mItemClearPath = New System.Windows.Forms.MenuItem
        Me.MenuItem14 = New System.Windows.Forms.MenuItem
        Me.MenuItem16 = New System.Windows.Forms.MenuItem
        Me.mItemOpenMap = New System.Windows.Forms.MenuItem
        Me.mItemSavePath = New System.Windows.Forms.MenuItem
        Me.mItemUploadProg = New System.Windows.Forms.MenuItem
        Me.MenuItem17 = New System.Windows.Forms.MenuItem
        Me.MenuItem18 = New System.Windows.Forms.MenuItem
        Me.MapTab = New System.Windows.Forms.TabControl
        Me.TabPage1 = New System.Windows.Forms.TabPage
        Me.Panel1 = New System.Windows.Forms.PictureBox
        Me.Panel2 = New System.Windows.Forms.Panel
        Me.lblTurns = New System.Windows.Forms.Label
        Me.lblNodes = New System.Windows.Forms.Label
        Me.txtActDisp = New System.Windows.Forms.TextBox
        Me.btnClear = New System.Windows.Forms.Button
        Me.btnBack = New System.Windows.Forms.Button
        Me.txtPathNodeDisp = New System.Windows.Forms.TextBox
        Me.btnSelectPathManually = New System.Windows.Forms.Button
        Me.StatusBar1 = New System.Windows.Forms.StatusBar
        Me.ToolBar1 = New System.Windows.Forms.ToolBar
        Me.tbbNew = New System.Windows.Forms.ToolBarButton
        Me.tbbOpenJob = New System.Windows.Forms.ToolBarButton
        Me.tbbSave = New System.Windows.Forms.ToolBarButton
        Me.ttbOpenMap = New System.Windows.Forms.ToolBarButton
        Me.tbbPathCalc = New System.Windows.Forms.ToolBarButton
        Me.tbbUploadProgram = New System.Windows.Forms.ToolBarButton
        Me.tbbUploadFirmware = New System.Windows.Forms.ToolBarButton
        Me.tbbHelp = New System.Windows.Forms.ToolBarButton
        Me.ImageList1 = New System.Windows.Forms.ImageList(Me.components)
        Me.TreeView1 = New System.Windows.Forms.TreeView
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.ttbUploadCalibration = New System.Windows.Forms.ToolBarButton
        Me.MapTab.SuspendLayout()
        Me.TabPage1.SuspendLayout()
        Me.Panel2.SuspendLayout()
        Me.SuspendLayout()
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem2, Me.MenuItem14, Me.MenuItem17})
        '
        'MenuItem1
        '
        Me.MenuItem1.Enabled = False
        Me.MenuItem1.Index = 0
        Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem5, Me.MenuItem8, Me.MenuItem11, Me.MenuItem12, Me.mFExit, Me.MenuItem21})
        Me.MenuItem1.Text = "File"
        '
        'MenuItem5
        '
        Me.MenuItem5.Index = 0
        Me.MenuItem5.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem7, Me.MenuItem6})
        Me.MenuItem5.Text = "New"
        '
        'MenuItem7
        '
        Me.MenuItem7.Index = 0
        Me.MenuItem7.Text = "Project"
        '
        'MenuItem6
        '
        Me.MenuItem6.Index = 1
        Me.MenuItem6.Text = "Job"
        '
        'MenuItem8
        '
        Me.MenuItem8.Index = 1
        Me.MenuItem8.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem10, Me.MenuItem9})
        Me.MenuItem8.Text = "Open"
        '
        'MenuItem10
        '
        Me.MenuItem10.Index = 0
        Me.MenuItem10.Text = "Project"
        '
        'MenuItem9
        '
        Me.MenuItem9.Index = 1
        Me.MenuItem9.Text = "Job"
        '
        'MenuItem11
        '
        Me.MenuItem11.Index = 2
        Me.MenuItem11.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem13, Me.MenuItem15})
        Me.MenuItem11.Text = "Close "
        '
        'MenuItem13
        '
        Me.MenuItem13.Index = 0
        Me.MenuItem13.Text = "Job"
        '
        'MenuItem15
        '
        Me.MenuItem15.Index = 1
        Me.MenuItem15.Text = "Project"
        '
        'MenuItem12
        '
        Me.MenuItem12.Index = 3
        Me.MenuItem12.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem22})
        Me.MenuItem12.Text = "Save"
        '
        'MenuItem22
        '
        Me.MenuItem22.Index = 0
        Me.MenuItem22.Text = ""
        '
        'mFExit
        '
        Me.mFExit.Index = 4
        Me.mFExit.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem19, Me.MenuItem20})
        Me.mFExit.Text = "Users"
        '
        'MenuItem19
        '
        Me.MenuItem19.Index = 0
        Me.MenuItem19.Text = "New User"
        '
        'MenuItem20
        '
        Me.MenuItem20.Index = 1
        Me.MenuItem20.Text = "Change User"
        '
        'MenuItem21
        '
        Me.MenuItem21.Index = 5
        Me.MenuItem21.Text = "Exit"
        '
        'MenuItem2
        '
        Me.MenuItem2.Index = 1
        Me.MenuItem2.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem3, Me.MenuItem4, Me.mItemManualPathSel, Me.mItemBack, Me.mItemClearPath})
        Me.MenuItem2.Text = "Edit"
        '
        'MenuItem3
        '
        Me.MenuItem3.Enabled = False
        Me.MenuItem3.Index = 0
        Me.MenuItem3.Text = "Undo"
        '
        'MenuItem4
        '
        Me.MenuItem4.Enabled = False
        Me.MenuItem4.Index = 1
        Me.MenuItem4.Text = "Redo"
        '
        'mItemManualPathSel
        '
        Me.mItemManualPathSel.Enabled = False
        Me.mItemManualPathSel.Index = 2
        Me.mItemManualPathSel.Text = "Manual Path Select"
        '
        'mItemBack
        '
        Me.mItemBack.Enabled = False
        Me.mItemBack.Index = 3
        Me.mItemBack.Text = "Back"
        '
        'mItemClearPath
        '
        Me.mItemClearPath.Enabled = False
        Me.mItemClearPath.Index = 4
        Me.mItemClearPath.Text = "Clear Path"
        '
        'MenuItem14
        '
        Me.MenuItem14.Index = 2
        Me.MenuItem14.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem16, Me.mItemOpenMap, Me.mItemSavePath, Me.mItemUploadProg})
        Me.MenuItem14.Text = "Project"
        '
        'MenuItem16
        '
        Me.MenuItem16.Enabled = False
        Me.MenuItem16.Index = 0
        Me.MenuItem16.Text = "Add Map"
        '
        'mItemOpenMap
        '
        Me.mItemOpenMap.Index = 1
        Me.mItemOpenMap.Text = "Open Map"
        '
        'mItemSavePath
        '
        Me.mItemSavePath.Index = 2
        Me.mItemSavePath.Text = "Save Path"
        '
        'mItemUploadProg
        '
        Me.mItemUploadProg.Index = 3
        Me.mItemUploadProg.Text = "Upload Program"
        '
        'MenuItem17
        '
        Me.MenuItem17.Index = 3
        Me.MenuItem17.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem18})
        Me.MenuItem17.Text = "Help"
        '
        'MenuItem18
        '
        Me.MenuItem18.Index = 0
        Me.MenuItem18.Text = "Help File"
        '
        'MapTab
        '
        Me.MapTab.Controls.Add(Me.TabPage1)
        Me.MapTab.HotTrack = True
        Me.MapTab.Location = New System.Drawing.Point(16, 48)
        Me.MapTab.Name = "MapTab"
        Me.MapTab.SelectedIndex = 0
        Me.MapTab.Size = New System.Drawing.Size(872, 584)
        Me.MapTab.TabIndex = 1
        Me.MapTab.Tag = ""
        '
        'TabPage1
        '
        Me.TabPage1.AccessibleName = "MapTab"
        Me.TabPage1.BackColor = System.Drawing.SystemColors.InactiveCaption
        Me.TabPage1.Controls.Add(Me.Panel1)
        Me.TabPage1.Controls.Add(Me.Panel2)
        Me.TabPage1.Location = New System.Drawing.Point(4, 22)
        Me.TabPage1.Name = "TabPage1"
        Me.TabPage1.Size = New System.Drawing.Size(864, 558)
        Me.TabPage1.TabIndex = 0
        Me.TabPage1.Text = "Map"
        '
        'Panel1
        '
        Me.Panel1.BackColor = System.Drawing.SystemColors.ControlLightLight
        Me.Panel1.Location = New System.Drawing.Point(8, 8)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(848, 416)
        Me.Panel1.TabIndex = 2
        Me.Panel1.TabStop = False
        '
        'Panel2
        '
        Me.Panel2.BackColor = System.Drawing.SystemColors.InactiveBorder
        Me.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Panel2.Controls.Add(Me.lblTurns)
        Me.Panel2.Controls.Add(Me.lblNodes)
        Me.Panel2.Controls.Add(Me.txtActDisp)
        Me.Panel2.Controls.Add(Me.btnClear)
        Me.Panel2.Controls.Add(Me.btnBack)
        Me.Panel2.Controls.Add(Me.txtPathNodeDisp)
        Me.Panel2.Controls.Add(Me.btnSelectPathManually)
        Me.Panel2.Location = New System.Drawing.Point(8, 432)
        Me.Panel2.Name = "Panel2"
        Me.Panel2.Size = New System.Drawing.Size(848, 104)
        Me.Panel2.TabIndex = 1
        '
        'lblTurns
        '
        Me.lblTurns.Location = New System.Drawing.Point(8, 72)
        Me.lblTurns.Name = "lblTurns"
        Me.lblTurns.Size = New System.Drawing.Size(48, 16)
        Me.lblTurns.TabIndex = 6
        Me.lblTurns.Text = "Turns"
        '
        'lblNodes
        '
        Me.lblNodes.ImageAlign = System.Drawing.ContentAlignment.MiddleRight
        Me.lblNodes.Location = New System.Drawing.Point(8, 40)
        Me.lblNodes.Name = "lblNodes"
        Me.lblNodes.Size = New System.Drawing.Size(48, 16)
        Me.lblNodes.TabIndex = 5
        Me.lblNodes.Text = "Nodes"
        '
        'txtActDisp
        '
        Me.txtActDisp.BackColor = System.Drawing.SystemColors.HighlightText
        Me.txtActDisp.Location = New System.Drawing.Point(64, 72)
        Me.txtActDisp.Name = "txtActDisp"
        Me.txtActDisp.ReadOnly = True
        Me.txtActDisp.Size = New System.Drawing.Size(768, 20)
        Me.txtActDisp.TabIndex = 4
        Me.txtActDisp.Text = ""
        '
        'btnClear
        '
        Me.btnClear.Enabled = False
        Me.btnClear.Location = New System.Drawing.Point(312, 8)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.Size = New System.Drawing.Size(112, 24)
        Me.btnClear.TabIndex = 3
        Me.btnClear.Text = "Clear"
        '
        'btnBack
        '
        Me.btnBack.Location = New System.Drawing.Point(176, 8)
        Me.btnBack.Name = "btnBack"
        Me.btnBack.Size = New System.Drawing.Size(120, 24)
        Me.btnBack.TabIndex = 2
        Me.btnBack.Text = "Back"
        '
        'txtPathNodeDisp
        '
        Me.txtPathNodeDisp.BackColor = System.Drawing.SystemColors.HighlightText
        Me.txtPathNodeDisp.Location = New System.Drawing.Point(64, 40)
        Me.txtPathNodeDisp.Name = "txtPathNodeDisp"
        Me.txtPathNodeDisp.ReadOnly = True
        Me.txtPathNodeDisp.Size = New System.Drawing.Size(768, 20)
        Me.txtPathNodeDisp.TabIndex = 1
        Me.txtPathNodeDisp.Text = ""
        '
        'btnSelectPathManually
        '
        Me.btnSelectPathManually.Location = New System.Drawing.Point(8, 8)
        Me.btnSelectPathManually.Name = "btnSelectPathManually"
        Me.btnSelectPathManually.Size = New System.Drawing.Size(120, 24)
        Me.btnSelectPathManually.TabIndex = 0
        Me.btnSelectPathManually.Text = "Select Path Manually"
        '
        'StatusBar1
        '
        Me.StatusBar1.Location = New System.Drawing.Point(0, 614)
        Me.StatusBar1.Name = "StatusBar1"
        Me.StatusBar1.Size = New System.Drawing.Size(882, 22)
        Me.StatusBar1.TabIndex = 2
        '
        'ToolBar1
        '
        Me.ToolBar1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.ToolBar1.Buttons.AddRange(New System.Windows.Forms.ToolBarButton() {Me.tbbNew, Me.tbbOpenJob, Me.tbbSave, Me.ttbOpenMap, Me.tbbPathCalc, Me.tbbUploadProgram, Me.tbbUploadFirmware, Me.ttbUploadCalibration, Me.tbbHelp})
        Me.ToolBar1.DropDownArrows = True
        Me.ToolBar1.ImageList = Me.ImageList1
        Me.ToolBar1.Location = New System.Drawing.Point(0, 0)
        Me.ToolBar1.Name = "ToolBar1"
        Me.ToolBar1.ShowToolTips = True
        Me.ToolBar1.Size = New System.Drawing.Size(882, 44)
        Me.ToolBar1.TabIndex = 3
        '
        'tbbNew
        '
        Me.tbbNew.Enabled = CType(configurationAppSettings.GetValue("tbbNew.Enabled", GetType(System.Boolean)), Boolean)
        Me.tbbNew.ImageIndex = 4
        Me.tbbNew.Text = "New"
        Me.tbbNew.ToolTipText = "Click fro new job"
        Me.tbbNew.Visible = False
        '
        'tbbOpenJob
        '
        Me.tbbOpenJob.Enabled = CType(configurationAppSettings.GetValue("tbbOpenJob.Enabled", GetType(System.Boolean)), Boolean)
        Me.tbbOpenJob.ImageIndex = 5
        Me.tbbOpenJob.Text = "Open"
        Me.tbbOpenJob.ToolTipText = "Click to Open Job"
        Me.tbbOpenJob.Visible = False
        '
        'tbbSave
        '
        Me.tbbSave.Enabled = CType(configurationAppSettings.GetValue("tbbSave.Enabled", GetType(System.Boolean)), Boolean)
        Me.tbbSave.ImageIndex = 6
        Me.tbbSave.Text = "Save"
        Me.tbbSave.ToolTipText = "Save"
        Me.tbbSave.Visible = False
        '
        'ttbOpenMap
        '
        Me.ttbOpenMap.Enabled = CType(configurationAppSettings.GetValue("ttbOpenMap.Enabled", GetType(System.Boolean)), Boolean)
        Me.ttbOpenMap.ImageIndex = 10
        Me.ttbOpenMap.Text = "Map"
        Me.ttbOpenMap.ToolTipText = "Click to open Map"
        '
        'tbbPathCalc
        '
        Me.tbbPathCalc.Enabled = CType(configurationAppSettings.GetValue("tbbPathCalc.Enabled", GetType(System.Boolean)), Boolean)
        Me.tbbPathCalc.ImageIndex = 0
        Me.tbbPathCalc.Text = "Path"
        Me.tbbPathCalc.ToolTipText = "Click to Calculate Path"
        '
        'tbbUploadProgram
        '
        Me.tbbUploadProgram.ImageIndex = 9
        Me.tbbUploadProgram.Text = "Upload Program"
        Me.tbbUploadProgram.ToolTipText = "Click to upload to Robot"
        '
        'tbbUploadFirmware
        '
        Me.tbbUploadFirmware.ImageIndex = 9
        Me.tbbUploadFirmware.Text = "Upload Firmware"
        Me.tbbUploadFirmware.ToolTipText = "Click to dowload robot data"
        Me.tbbUploadFirmware.Visible = False
        '
        'tbbHelp
        '
        Me.tbbHelp.ImageIndex = 8
        Me.tbbHelp.Text = "Help"
        Me.tbbHelp.ToolTipText = "Click to open help"
        '
        'ImageList1
        '
        Me.ImageList1.ImageSize = New System.Drawing.Size(16, 16)
        Me.ImageList1.ImageStream = CType(resources.GetObject("ImageList1.ImageStream"), System.Windows.Forms.ImageListStreamer)
        Me.ImageList1.TransparentColor = System.Drawing.Color.Transparent
        '
        'TreeView1
        '
        Me.TreeView1.ImageIndex = -1
        Me.TreeView1.Location = New System.Drawing.Point(0, 48)
        Me.TreeView1.Name = "TreeView1"
        Me.TreeView1.Nodes.AddRange(New System.Windows.Forms.TreeNode() {New System.Windows.Forms.TreeNode("Map", New System.Windows.Forms.TreeNode() {New System.Windows.Forms.TreeNode("Map"), New System.Windows.Forms.TreeNode("Map with Path"), New System.Windows.Forms.TreeNode("Map with Exit Path")}), New System.Windows.Forms.TreeNode("Data Analysis", New System.Windows.Forms.TreeNode() {New System.Windows.Forms.TreeNode("Path ", New System.Windows.Forms.TreeNode() {New System.Windows.Forms.TreeNode("Path Calculated"), New System.Windows.Forms.TreeNode("Path Taken")}), New System.Windows.Forms.TreeNode("Blockages Removed"), New System.Windows.Forms.TreeNode("Log")}), New System.Windows.Forms.TreeNode("Robot Communication", New System.Windows.Forms.TreeNode() {New System.Windows.Forms.TreeNode("Upload"), New System.Windows.Forms.TreeNode("Download")})})
        Me.TreeView1.SelectedImageIndex = -1
        Me.TreeView1.Size = New System.Drawing.Size(16, 584)
        Me.TreeView1.TabIndex = 4
        Me.TreeView1.Visible = False
        '
        'ttbUploadCalibration
        '
        Me.ttbUploadCalibration.ImageIndex = 9
        Me.ttbUploadCalibration.Text = "Upload Calibration"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(882, 636)
        Me.Controls.Add(Me.TreeView1)
        Me.Controls.Add(Me.ToolBar1)
        Me.Controls.Add(Me.StatusBar1)
        Me.Controls.Add(Me.MapTab)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.MaximizeBox = False
        Me.Menu = Me.MainMenu1
        Me.Name = "Form1"
        Me.Text = "Blockage Remover"
        Me.MapTab.ResumeLayout(False)
        Me.TabPage1.ResumeLayout(False)
        Me.Panel2.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region
    Private Sub mFOpenProj_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        ' Create a new OpenFileDialog and display it.
        Dim fd As New OpenFileDialog
        fd.DefaultExt = "*.*"
        fd.ShowDialog()
    End Sub
    Private Sub MenuItem21_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem21.Click
        Close()
    End Sub
    Private Sub tbbNew_ButtonClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ToolBarButtonClickEventArgs)
        ' Create a new OpenFileDialog and display it.
        Dim fd As New OpenFileDialog
        fd.DefaultExt = "*.*"
        fd.ShowDialog()
    End Sub
    Private Sub ToolBar1_ButtonClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ToolBarButtonClickEventArgs) Handles ToolBar1.ButtonClick
        Select Case ToolBar1.Buttons.IndexOf(e.Button)
            Case 0

            Case 1

            Case 2
                Dim fd As New SaveFileDialog
                fd.DefaultExt = "*.*"
                fd.ShowDialog()
            Case 3 'open a map
                OpenMapWrapper()
            Case 4             ' save the header file
                If ActSize < 3 Then
                    MsgBox("No path to save")
                    Exit Sub
                End If
                Dim fdPath As New SaveFileDialog
                fdPath.DefaultExt = "*.h"
                fdPath.Filter = "Header File (*.h)|*.h|All files (*.*)|*.*"
                fdPath.ShowDialog()
                If (fdPath.FileName = "") Then
                    Exit Sub
                End If
                SavePathFile(fdPath.FileName)
            Case 5
                UploadJob()
            Case 6
                If (MsgBox("Uploading firmware can erase all the existing programing RCX. Still want to upload?", MsgBoxStyle.YesNo) = MsgBoxResult.No) Then
                    Exit Sub
                End If
                UploadFirmware()
            Case 7
                UploadCali()
            Case 8
                OpenHelp()
        End Select
    End Sub
    Private Sub MenuItem7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem7.Click
        Dim username As Object
        Dim password As Object
        username = InputBox("Enter User Name:", "User Settings")
        MsgBox("User Name does not exist would you like the create it?", MsgBoxStyle.OKCancel)
        password = InputBox("Enter Password:", "User Settings")
        password = InputBox("Re-Enter Password:", "User Settings")
    End Sub
    Private Sub Panel1_Paint1(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Panel1.Paint
        Dim MinX, MaxX, MinY, MaxY As Double
        Dim lX, rX, botY, topY As Integer
        Dim cnt, i, tmpEb, tmpEe As Integer
        Dim rateX, rateY As Double
        Dim tmpSX, tmpSY As Integer
        Dim vecX, vecY, vecZ, vX, vY, vecNorm, vNorm, tmpX, tmpY As Double
        Dim ang, dx, dy As Integer
        Dim rate180PI As Double
        Dim p As New Pen(Color.FromArgb(255, 0, 0, 0), 1)
        Dim pEdge As New Pen(Color.FromArgb(255, 100, 100, 255), 1)
        Dim pOpen As New Pen(Color.FromArgb(255, 0, 170, 0), 1)
        Dim pBlok As New Pen(Color.FromArgb(255, 200, 0, 0), 1)
        Dim fontFamily As New FontFamily("Times New Roman")
        Dim font As New Font(fontFamily, 15, FontStyle.Bold, GraphicsUnit.Pixel)
        Dim nodeBrush As New SolidBrush(Color.FromArgb(255, 100, 100, 255))
        Dim blackBrush As New SolidBrush(Color.FromArgb(255, 0, 0, 0))
        Dim greenBrush As New SolidBrush(Color.FromArgb(255, 0, 170, 0))
        Dim redBrush As New SolidBrush(Color.FromArgb(255, 255, 0, 0))
        Dim pF As New PointF(10, 10)
        Dim rect As New Rectangle
        Dim rectf As New RectangleF

        If (stateMapLoaded = False) Then
            ' the map is not loaded, do not draw
            Exit Sub
        End If

        'initialize the real world parameters
        MinX = Map(1).x
        MaxX = Map(1).x
        MinY = Map(1).y
        MaxY = Map(1).y
        For cnt = 2 To NN
            If (Map(cnt).x < MinX) Then
                MinX = Map(cnt).x
            ElseIf (Map(cnt).x > MaxX) Then
                MaxX = Map(cnt).x
            End If
            If (Map(cnt).y < MinY) Then
                MinY = Map(cnt).y
            ElseIf (Map(cnt).y > MaxY) Then
                MaxY = Map(cnt).y
            End If
        Next cnt

        'initialize the screen parameters
        lX = 50
        rX = Panel1.Width - 60
        botY = Panel1.Height - 40
        topY = 30

        'get the convertion rate between screen and real world
        rateX = (rX - lX) / (MaxX - MinX)
        rateY = (botY - topY) / (MaxY - MinY)

        'fill the screenX and screenY
        ReDim screenX(NN)
        ReDim screenY(NN)
        For cnt = 1 To NN
            screenX(cnt) = lX + CInt(Round(rateX * (Map(cnt).x - MinX), 0))
            screenY(cnt) = botY - CInt(Round(rateY * (Map(cnt).y - MinY), 0))
        Next cnt

        'display the nodes indices of each node
        For cnt = 1 To NN
            pF.X = screenX(cnt) + 2
            pF.Y = screenY(cnt) + 2
            e.Graphics.FillRectangle(nodeBrush, _
                                     screenX(cnt) - 5, screenY(cnt) - 5, _
                                     10, 10)
            e.Graphics.DrawString(CStr(cnt), font, nodeBrush, pF)
        Next cnt

        'draw the pipe network
        pEdge.Width = 5
        For cnt = 1 To NE
            e.Graphics.DrawLine(pEdge, screenX(Edges(cnt).b), screenY(Edges(cnt).b), _
                                   screenX(Edges(cnt).e), screenY(Edges(cnt).e))
        Next cnt

        'draw the opens
        rect.Width = 16
        rect.Height = 16
        For cnt = 1 To NO
            rect.X = screenX(Opens(cnt)) - 8
            rect.Y = screenY(Opens(cnt)) - 8
            e.Graphics.DrawRectangle(pOpen, rect)
        Next cnt

        'draw the blockages
        rect.Width = 16
        rect.Width = 16
        For cnt = 1 To NB
            ' get the unit vector flow in the edge 
            tmpEb = Edges(Blocks(cnt).e).b
            tmpEe = Edges(Blocks(cnt).e).e
            vecX = Map(tmpEe).x - Map(tmpEb).x
            vecY = Map(tmpEe).y - Map(tmpEb).y
            vecZ = Map(tmpEe).z - Map(tmpEb).z
            vecNorm = Sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ)
            vecX = vecX / vecNorm
            vecY = vecY / vecNorm
            ' get the position of blockage and construct the rectangles
            tmpX = Map(Edges(Blocks(cnt).e).b).x + vecX * (Blocks(cnt).d)
            tmpY = Map(Edges(Blocks(cnt).e).b).y + vecY * (Blocks(cnt).d)
            rect.X = lX + CInt(Round(rateX * (tmpX - MinX), 0)) - 8
            rect.Y = botY - CInt(Round(rateY * (tmpY - MinY), 0)) - 8
            If (BlockFlags(cnt) = 0) Then
                e.Graphics.DrawRectangle(pBlok, rect)
            Else
                e.Graphics.FillRectangle(redBrush, rect)
            End If
        Next cnt

        'draw the reference x-axis
        rect.Y = botY + 20
        For cnt = 0 To 4
            tmpX = MinX + cnt * (MaxX - MinX) / 4
            rect.X = lX + CInt(Round(rateX * (tmpX - MinX), 0))
            e.Graphics.DrawLine(p, rect.X, rect.Y, rect.X, rect.Y - 4)
            e.Graphics.DrawString(CStr(Round(tmpX, 1)), font, blackBrush, rect.X, rect.Y)
        Next
        e.Graphics.DrawLine(p, lX, botY + 20, rX, botY + 20)

        'draw the reference y-axis
        rect.X = lX - 46
        For cnt = 0 To 4
            tmpY = MinY + cnt * (MaxY - MinY) / 4
            rect.Y = botY - CInt(Round(rateY * (tmpY - MinY), 0))
            e.Graphics.DrawLine(p, rect.X, rect.Y, rect.X + 4, rect.Y)
            e.Graphics.DrawString(CStr(Round(tmpY, 1)), font, blackBrush, rect.X, rect.Y)
        Next
        e.Graphics.DrawLine(p, lX - 46, topY, lX - 46, botY)

        'draw the path
        If (iPathNodeSize < 1) Then
            Exit Sub
        End If
        e.Graphics.FillRectangle(greenBrush, screenX(iPathNode(1)) - 8, _
                                 screenY(iPathNode(1)) - 8, 16, 16)
        Dim TM As New Matrix
        rate180PI = 180 / Math.PI
        pOpen.Width = 3
        For i = 2 To iPathNodeSize
            dx = screenX(iPathNode(i)) - screenX(iPathNode(i - 1))
            dy = screenY(iPathNode(i)) - screenY(iPathNode(i - 1))
            pF.X = screenX(iPathNode(i - 1)) + CInt(dx / 2)
            pF.Y = screenY(iPathNode(i - 1)) + CInt(dy / 2)
            ang = CInt(rate180PI * GetAngle(dx, dy))
            TM.RotateAt(ang, pF)
            e.Graphics.Transform = TM
            e.Graphics.DrawLine(pOpen, pF.X, pF.Y, pF.X - 20, pF.Y - 8)
            e.Graphics.DrawLine(pOpen, pF.X, pF.Y, pF.X - 20, pF.Y + 8)
            TM.Reset()
            e.Graphics.Transform = TM
            e.Graphics.FillRectangle(greenBrush, screenX(iPathNode(i)) - 5, screenY(iPathNode(i)) - 5, 10, 10)
        Next
        pOpen.Width = 1
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        stateMapLoaded = False
        nodeClickingMode = False
        iPathNodeSize = 0
        ActSize = 0
        btnSelectPathManually.Enabled = False
        mItemManualPathSel.Enabled = False
        btnBack.Enabled = False
        mItemBack.Enabled = False
        StatusBar1.Text = "no map is open"
    End Sub
    Private Sub Panel1_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Panel1.MouseDown
        Dim i As Integer
        Dim dx, dy As Integer
        ' decide if it should detect the mouse location
        If (Not nodeClickingMode) Then
            Exit Sub
        End If
        ' decide which node is clicked
        For i = 1 To NN
            dx = Abs(e.X - screenX(i))
            dy = Abs(e.Y - screenY(i))
            If (dx < 6) And (dy < 6) Then
                iNodeClicked = i
                Exit Sub
            End If
        Next
        iNodeClicked = -1
    End Sub
    Private Sub OpenMapWrapper()
        Dim fdopen As New OpenFileDialog
        Dim readmapMsg As String
        Dim chkMsg As String
        Dim newSuccess As Boolean
        fdopen.DefaultExt = "*.txt"
        fdopen.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*"
        fdopen.ShowDialog()
        If (fdopen.FileName = "") Then
            Exit Sub
        End If
        fdopen.OpenFile()
        ' do the checksum on the map file
        chkMsg = VerifyData(fdopen.FileName, 0)
        If Not (chkMsg = "") Then
            MsgBox("error when reading " + fdopen.FileName _
                   + Chr(13) + "  " + chkMsg)
            fdopen.Dispose()
            fdopen = Nothing
            Exit Sub
        End If
        ' read the data from map file
        readmapMsg = ReadMap(fdopen.FileName)
        If (readmapMsg = "") Then
            stateMapLoaded = True
            Me.Text = "Blockage REmover --" + fdopen.FileName
            newSuccess = True
        ElseIf Not (readmapMsg.Chars(0) = "@") Then
            MsgBox("error when reading " + fdopen.FileName _
                   + Chr(13) + "  " + readmapMsg)
            newSuccess = False
        Else
            readmapMsg = readmapMsg.Remove(0, 1)
            MsgBox("warning when opening " + fdopen.FileName _
                   + Chr(13) + "  " + readmapMsg)
            stateMapLoaded = True
            Me.Text = "Blockage Remover --" + fdopen.FileName
            newSuccess = True
        End If
        fdopen.Dispose()
        fdopen = Nothing
        ' draw the map
        Try
            Panel1.Refresh()
        Catch
            MsgBox("unknown error in drawing map")
        End Try
        ' initialize some other controls
        btnClear.Enabled = False
        mItemClearPath.Enabled = False
        btnBack.Enabled = False
        mItemBack.Enabled = False
        btnSelectPathManually.Enabled = True
        mItemManualPathSel.Enabled = True
        txtPathNodeDisp.Text = ""
        txtActDisp.Text = ""
        ' check the semantic of new loaded map
        If newSuccess Then
            chkMsg = VerifyMap()
            If Not (chkMsg = "") Then
                LockFunction(True)
                chkMsg = chkMsg.Remove(0, 1)
                MsgBox("Unusual attributes are found in the map, and the current version can not handle " _
                       + Chr(13) + "  " + chkMsg)
                StatusBar1.Text = "map is loaded, but the map is not fully supported by the current version"
            Else
                LockFunction(False)
                StatusBar1.Text = "map is loaded"
            End If
        Else
            StatusBar1.Text = "map is loaded, but the map is not fully supported by the current version"
        End If
    End Sub
    Private Sub Panel1_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Panel1.MouseUp
        Dim ib As Integer
        If (Not nodeClickingMode) Then
            Exit Sub
        End If
        If (iNodeClicked < 0) Then
            Exit Sub
        End If
        If (iPathNodeSize > 199) Then
            MsgBox("Path too long, cannot go further")
            Exit Sub
        End If
        If ((iPathNodeSize > 0) And (NodeToEdge(iPathNode(iPathNodeSize), iNodeClicked) > 0)) Then
            ' already start with an open
            iPathNodeSize = iPathNodeSize + 1
            iPathNode(iPathNodeSize) = iNodeClicked
            txtPathNodeDisp.Text = txtPathNodeDisp.Text + ", " + CStr(iNodeClicked)
            ActSize = ActSize + 1
            If (ActSize > 2) Then           '*******2*******
                ' turns can be calculated
                ib = FindBlock(NodeToEdge(iPathNode(iPathNodeSize - 1), iPathNode(iPathNodeSize)))
                If ib > 0 Then               '*****1******
                    ' there is blocks in the pass over edge
                    Act(ActSize) = getTurn(iPathNode(iPathNodeSize - 2), _
                                           iPathNode(iPathNodeSize - 1), _
                                           iPathNode(iPathNodeSize))
                    Act(ActSize) = Act(ActSize).ToLower()
                    txtActDisp.Text = txtActDisp.Text + ", " + Act(ActSize)
                    BlockFlags(ib) = 1
                Else
                    ' no blocks in the pass over edge
                    Act(ActSize) = getTurn(iPathNode(iPathNodeSize - 2), _
                                           iPathNode(iPathNodeSize - 1), _
                                           iPathNode(iPathNodeSize))
                    If (Act(ActSize) = "-") Then
                        MsgBox("warning: invalid turn in an invalid map is selected," _
                    + Chr(13) + "         the current version of robot is not supporting this function," _
                    + Chr(13) + "         please press [Back] button and select the next node again")
                    End If
                    txtActDisp.Text = txtActDisp.Text + ", " + Act(ActSize)
                End If                        '*****1*******

            ElseIf (ActSize = 2) Then         '*******2******
                ' the turn must be forward
                ib = FindBlock(NodeToEdge(iPathNode(1), iPathNode(2)))
                If (ib > 0) Then              '******1******
                    ' pass over a block
                    Act(ActSize) = "f"
                    txtActDisp.Text = txtActDisp.Text + ", f"
                    BlockFlags(ib) = 1
                Else

                    ' no block to pass over
                    Act(ActSize) = "F"
                    txtActDisp.Text = txtActDisp.Text + ", F"
                End If                         '**********1*********
            End If
        ElseIf ((iPathNodeSize = 0) And (NodeToOpen(iNodeClicked) > 0)) Then         '****2****
            ' the first point to click is an open
            iPathNodeSize = 1
            iPathNode(iPathNodeSize) = iNodeClicked
            txtPathNodeDisp.Text = CStr(iNodeClicked)
            ActSize = 1
            txtActDisp.Text = ">"
        ElseIf (iPathNodeSize = 0) Then
            ' open is not clicked for the first point
            MsgBox("The first node should be an open")
        Else
            MsgBox("Next node must be a neighbor of last node")
        End If
        btnBack.Enabled = True
        mItemBack.Enabled = True
        btnClear.Enabled = True
        mItemClearPath.Enabled = True
        Panel1.Refresh()
    End Sub
    Private Sub LockFunction(ByVal flag As Boolean)
        If flag = False Then

            ToolBar1.Buttons(6).Enabled = True
        Else

            ToolBar1.Buttons(6).Enabled = False
        End If
    End Sub
    Private Sub btnSelectPathManually_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectPathManually.Click
        If nodeClickingMode Then
            nodeClickingMode = False
            TreeView1.Enabled = True
            ToolBar1.Enabled = True
            MenuItem14.Enabled = True
            btnSelectPathManually.Text = "Select Path Manually"
            mItemManualPathSel.Text = "Manual Path Select"
        Else
            nodeClickingMode = True
            TreeView1.Enabled = False
            ToolBar1.Enabled = False
            MenuItem14.Enabled = False
            btnSelectPathManually.Text = "OK"
            mItemManualPathSel.Text = "Path Select OK"
        End If

    End Sub
    Private Sub btnBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBack.Click
        Dim ib As Integer
        ' try to recover the blockage if the last pipe has a blockage
        If (iPathNodeSize > 1) Then
            ib = FindBlockOrigin(NodeToEdge(iPathNode(iPathNodeSize - 1), iPathNode(iPathNodeSize)))
            If (ib > 0) Then
                BlockFlags(ib) = 0
            End If
        End If
        ' take care of other things
        ActSize = ActSize - 1
        iPathNodeSize = iPathNodeSize - 1
        If iPathNodeSize = 0 Then
            btnBack.Enabled = False
            mItemBack.Enabled = False
            btnClear.Enabled = False
            mItemClearPath.Enabled = False
            txtPathNodeDisp.Text = ""
            txtActDisp.Text = ""
            initFlgArray(BlockFlags, NB, 0)
        Else
            txtPathNodeDisp.Text = txtPathNodeDisp.Text.Substring(0, txtPathNodeDisp.Text.LastIndexOf(","))
            txtActDisp.Text = txtActDisp.Text.Substring(0, txtActDisp.Text.LastIndexOf(","))
        End If
        Panel1.Refresh()
    End Sub
    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        If MsgBox("Are you sure?", MsgBoxStyle.YesNo) = MsgBoxResult.No Then
            Exit Sub
        End If
        iPathNodeSize = 0
        ActSize = 0
        txtPathNodeDisp.Text = ""
        txtActDisp.Text = ""
        initFlgArray(BlockFlags, NB, 0)
        btnBack.Enabled = False
        mItemBack.Enabled = False
        btnClear.Enabled = False
        mItemClearPath.Enabled = False
        Panel1.Refresh()
    End Sub
    Private Sub mItemManualPathSel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemManualPathSel.Click
        btnSelectPathManually_Click(Me, e)
    End Sub
    Private Sub mItemBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemBack.Click
        btnBack_Click(Me, e)
    End Sub
    Private Sub mItemClearPath_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemClearPath.Click
        btnClear_Click(Me, e)
    End Sub
    Private Sub mItemOpenMap_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemOpenMap.Click
        OpenMapWrapper()
    End Sub
    Private Sub mItemSavePath_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemSavePath.Click
        If ActSize < 3 Then
            MsgBox("No path to save")
            Exit Sub
        End If
        Dim fdPath As New SaveFileDialog
        fdPath.DefaultExt = "*.h"
        fdPath.Filter = "Header File (*.h)|*.h|All files (*.*)|*.*"
        fdPath.ShowDialog()
        If (fdPath.FileName = "") Then
            Exit Sub
        End If
        SavePathFile(fdPath.FileName)
    End Sub
    Private Sub mItemUploadProg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mItemUploadProg.Click
        Shell("c:\cygwin\uploadprog.bat")
    End Sub
End Class
Module wGetMap
    Public Structure NodeType
        Dim x As Double
        Dim y As Double
        Dim z As Double
        Dim neighCnt As Integer
        Dim neighbors() As Integer
        Dim eIndex() As Integer
        Dim widthE() As Double
    End Structure
    Public Structure EdgeType
        Dim b As Integer
        Dim e As Integer
        Dim w As Double
    End Structure
    Public Structure BlockType
        Dim e As Integer
        Dim d As Double
    End Structure

    'the variables storing a map
    Public Map() As NodeType
    Public Edges() As EdgeType
    Public Opens() As Integer
    Public Blocks() As BlockType
    Public NN, NE, NO, NB As Integer

    'global variable for reading file
    Dim sr As StreamReader
    Dim TmpLine As String
    Public EdgeFlags() As Integer
    Public NodeFlags() As Integer
    Public BlockFlags() As Integer

    ' variables for math calculation
    Const TOL As Double = 0.01

    ' variables for the path and action
    Public iPathNodeSize As Integer
    Public iPathNode(200) As Integer
    Public ActSize As Integer
    Public Act(200) As String
    ' Access functions in MIS/MID
    Public Function ReadMap(ByVal filename As String) As String
        'Post:
        '  1. Return empty string for correct reading
        '  2. None empty string to describe the error in the reading
        '  3. Return warning if there is unusual issue but map can still be read

        Dim NumStream() As Double
        Dim ptr, i, j, NumStreamSize, resultcode As Integer
        Dim tmpDbl As Double
        Dim tMap() As NodeType
        Dim tEdges() As EdgeType
        Dim tOpens() As Integer
        Dim tBlocks() As BlockType
        Dim tNN, tNE, tNO, tNB As Integer
        Dim warn As String

        ' open the stream reader
        sr = New StreamReader(filename)

        'initialize the global string buffer
        TmpLine = ""
        warn = ""

        ' read control numbers tNN, tNE, tNO, tNB
        tmpDbl = GetOneNumber(sr, resultcode)
        If ((resultcode = 0)) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect numeric format for number of nodes (NN)"
        ElseIf (resultcode = -2) Then
            sr.Close()
            sr = Nothing
            Return "Incompleted map"
        ElseIf (resultcode = -1) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect data format for number of nodes (NN)"
        Else
            tNN = CInt(tmpDbl)
        End If
        tmpDbl = GetOneNumber(sr, resultcode)
        If ((resultcode = 0)) Then
            Return "Incorrect numeric format for number of edges (NE)"
        ElseIf (resultcode = -2) Then
            sr.Close()
            sr = Nothing
            Return "Incompleted map"
        ElseIf (resultcode = -1) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect data format for number of nodes (NE)"
        Else
            tNE = CInt(tmpDbl)
        End If
        tmpDbl = GetOneNumber(sr, resultcode)
        If ((resultcode = 0)) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect numeric format for number of opens (NO)"
        ElseIf (resultcode = -2) Then
            sr.Close()
            sr = Nothing
            Return "Incompleted map"
        ElseIf (resultcode = -1) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect data format for number of nodes (NO)"
        Else
            tNO = CInt(tmpDbl)
        End If
        tmpDbl = GetOneNumber(sr, resultcode)
        If ((resultcode = 0)) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect numeric format for number of blockages (NB)"
        ElseIf (resultcode = -2) Then
            sr.Close()
            sr = Nothing
            Return "Incompleted map"
        ElseIf (resultcode = -1) Then
            sr.Close()
            sr = Nothing
            Return "Incorrect data format for number of nodes (NB)"
        Else
            tNB = CInt(tmpDbl)
        End If
        ' read all the numbers into a large temporary array
        NumStreamSize = tNN * 3 + tNE * 3 + tNO + tNB * 2
        ReDim NumStream(NumStreamSize)
        For i = 1 To NumStreamSize
            NumStream(i) = GetOneNumber(sr, resultcode)
            If (resultcode < 0) Then
                sr.Close()
                sr = Nothing
                Return "Error: Incorrect numbering of nodes, edges, opens, or blockages"
            End If
        Next
        ' check if there is anymore data following
        tmpDbl = GetOneNumber(sr, resultcode)
        If ((resultcode >= 0) And (warn = "")) Then
            warn = "@Redundant data"
        End If
        ' raw data reading finished, close the stream reader and file
        sr.Close()
        sr = Nothing
        ' initlize the pointer before putting numbers into Map data structure
        ptr = 1
        ' initialize the Map and fill in the coordinates
        ReDim tMap(tNN)
        For i = 1 To tNN
            tMap(i).x = NumStream(ptr)
            ptr = ptr + 1
            tMap(i).y = NumStream(ptr)
            ptr = ptr + 1
            tMap(i).z = NumStream(ptr)
            ptr = ptr + 1
            tMap(i).neighCnt = 0
            ReDim tMap(i).neighbors(6)
            ReDim tMap(i).eIndex(6)
            ReDim tMap(i).widthE(6)
        Next i
        ' build Edges and finish Map
        ReDim tEdges(tNE)
        For i = 1 To tNE
            If (NumType(NumStream(ptr)) < 2) Then
                Return "Error: Incorrect numbering of nodes or edges"
            End If
            tEdges(i).b = CInt(NumStream(ptr))
            ptr = ptr + 1
            If (NumType(NumStream(ptr)) < 2) Then
                Return "Error: Incorrect numbering of nodes or edges"
            End If
            tEdges(i).e = CInt(NumStream(ptr))
            ptr = ptr + 1
            If (NumStream(ptr) <= 0) Then
                Return "Width of edge " + CStr(i) + " must be strictly positive"
            End If
            tEdges(i).w = NumStream(ptr)
            ptr = ptr + 1
            With tEdges(i)
                If ((.b > tNN) Or ((.e) > tNN)) Then
                    Return "Indexing error of edge " + CStr(i) + ": not existing node"
                End If
                tMap(.b).neighCnt = tMap(.b).neighCnt + 1
                tMap(.b).neighbors(tMap(.b).neighCnt) = .e
                tMap(.b).eIndex(tMap(.b).neighCnt) = i
                tMap(.b).widthE(tMap(.b).neighCnt) = .w
                tMap(.e).neighCnt = tMap(.e).neighCnt + 1
                tMap(.e).neighbors(tMap(.e).neighCnt) = .b
                tMap(.e).eIndex(tMap(.e).neighCnt) = i
                tMap(.e).widthE(tMap(.e).neighCnt) = .w
            End With
        Next i
        ' build Opens
        ReDim tOpens(tNO)
        For i = 1 To tNO
            If (NumType(NumStream(ptr)) < 2) Then
                Return "Indexing error of open " + CStr(i) + ": must be strictly positive integer"
            ElseIf (NumStream(ptr) > tNN) Then
                Return "Indexing error of open " + CStr(i) + ": not existing node"
            End If
            tOpens(i) = CInt(NumStream(ptr))
            ptr = ptr + 1
        Next i
        ' build Blocks
        ReDim tBlocks(tNB)
        For i = 1 To tNB
            If (NumType(NumStream(ptr)) < 2) Then
                Return "Indexing error of blockage " + CStr(i) + ": must be strictly positive integer"
            ElseIf (NumStream(ptr) > tNE) Then
                Return "Indexing error of blockage " + CStr(i) + ": not existing edge"
            End If
            tBlocks(i).e = CInt(NumStream(ptr))
            ptr = ptr + 1
            tBlocks(i).d = NumStream(ptr)
            ptr = ptr + 1
        Next i

        ' close the stream reader
        Map = tMap
        Edges = tEdges
        Opens = tOpens
        Blocks = tBlocks
        NN = tNN
        NE = tNE
        NO = tNO
        NB = tNB

        ' reset the path
        ActSize = 0
        iPathNodeSize = 0

        ' reset the array EdgeFlags and BlockFlags
        ReDim EdgeFlags(NE)
        initFlgArray(EdgeFlags, NE, 0)
        ReDim BlockFlags(NB)
        initFlgArray(BlockFlags, NB, 0)
        ReDim NodeFlags(NN)
        initFlgArray(NodeFlags, NN, 10000)

        ' return
        Return warn
    End Function
    Public Function VerifyData(ByVal filename As String, ByVal strictness As Integer) As String
        ' pre:
        '    1. if strictness=0 then not strict
        '    2. if strictness=1 then strict
        ' post:
        '    1. if no error, return an empty string
        '    2. if error, return corresponding message
        '    3. warnings will start with "@"
        Dim i, j As Integer
        Dim c As Char

        ' initialization
        sr = New StreamReader(filename)
        TmpLine = ""

        If (strictness = 0) Then
            ' loop through each line
            While (Not (sr.Peek < 0))
                TmpLine = sr.ReadLine
                ' check this individually line
                For j = 0 To (TmpLine.Length - 1)
                    c = TmpLine.Chars(j)
                    If Not (Char.IsNumber(c) _
                            Or Char.IsWhiteSpace(c) _
                            Or (c = ".") _
                            Or (c = "+") _
                            Or (c = "-") _
                            Or (c = "e") _
                            Or (c = "E")) _
                            Then
                        Return "invalid character in file: " + c
                    End If
                Next
            End While
        Else
            While (Not (sr.Peek < 0))
                TmpLine = sr.ReadLine
                ' check this individually line
                For j = 0 To (TmpLine.Length - 1)
                    c = TmpLine.Chars(j)
                    If Not (Char.IsNumber(c) _
                            Or Char.IsWhiteSpace(c) _
                            Or (c = ".") _
                            Or (c = "+") _
                            Or (c = "-")) _
                            Then
                        Return "invalid character in file: " + c
                    End If
                Next
            End While
        End If
        Return ""
    End Function
    Public Function VerifyMap() As String
        'post:
        '    1. returns "" if cannot find any problem in the map
        '    2. returns a descriptive string if there is potential problem in the map
        Dim warn As String
        Dim i, j As Integer
        Dim tolerance As Double
        Dim v1X, v1Y, v2X, v2Y, dotProd, vL, ang1, ang2, angD As Double
        Dim n(6) As Double
        Dim numIntersect As Integer
        Dim angbuf(3) As Integer

        ' initialize tolerance
        tolerance = 0.01

        ' get the number of intersections
        numIntersect = 0
        For i = 1 To NN
            If Map(i).neighCnt > 1 Then
                numIntersect = numIntersect + 1
            End If
        Next
        ' check the control parameters and intersections
        If (numIntersect > 19) Then
            warn = addWarn(warn, "too many intersections")
        End If
        If (NE > 20) Then
            warn = addWarn(warn, "too many edges")
        End If
        If (NB < 1) Then
            warn = addWarn(warn, "no blockages")
        ElseIf (NB > 3) Then
            warn = addWarn(warn, "too many blockages")
        End If
        If (NO > NN) Then
            warn = addWarn(warn, "too many opens")
        End If

        ' check the degree of each open
        For i = 1 To NO
            If (Map(Opens(i)).neighCnt > 1) Then
                warn = addWarn(warn, "Invalid map since opening " + CStr(i) + " at node " + CStr(Opens(i)) + " is located at an interior point.")
            End If
            If Map(Opens(i)).neighCnt = 0 Then
                warn = addWarn(warn, "Open " + CStr(i) + " is at a zero degree node (node " + CStr(Opens(i)) + ")")
            End If
            For j = (i + 1) To NO
                If (Opens(i) = Opens(j)) Then
                    warn = addWarn(warn, "Opens " + CStr(i) + " and " + CStr(j) + " are both at node " + CStr(Opens(i)))
                End If
            Next
        Next

        ' check the degree of each node and the angles between incident edges
        For i = 1 To NN
            With Map(i)
                ' check the degree
                If .neighCnt > 3 Then
                    warn = addWarn(warn, "Node " + CStr(i) + " is having too large degree")
                End If
                ' check the angles
                If .neighCnt > 1 Then
                    ' get the length of all edges
                    For j = 1 To .neighCnt
                        n(j) = edgeLength(.eIndex(j))
                        If n(j) < (6) Then
                            warn = addWarn(warn, "nodes are too close: " + CStr(i) + " and " + CStr(.eIndex(j)))
                            Return warn
                        End If
                    Next
                    ' get the unit vector of edge 1
                    v1X = Map(.neighbors(1)).x - .x
                    v1Y = Map(.neighbors(1)).y - .y
                    ang1 = GetAngle(v1X, v1Y)
                    For j = 1 To 3
                        angbuf(j) = 0
                    Next
                    ' loop through all other unit vectors
                    For j = 2 To .neighCnt
                        v2X = Map(.neighbors(j)).x - .x
                        v2Y = Map(.neighbors(j)).y - .y
                        ang2 = GetAngle(v2X, v2Y)
                        angD = (ang2 - ang1 + 2 * PI) Mod (2 * PI)
                        If ((Abs(angD - 0.5 * PI) < 0.1) And (angbuf(1) = 0)) Then
                            angbuf(1) = 1
                        ElseIf ((Abs(angD - PI) < 0.1) And (angbuf(2) = 0)) Then
                            angbuf(2) = 1
                        ElseIf ((Abs(angD - 1.5 * PI) < 0.1) And (angbuf(3) = 0)) Then
                            angbuf(3) = 1
                        Else
                            warn = addWarn(warn, "the edges at node " + CStr(i) + " have complicated angle")
                            Exit For
                        End If
                    Next
                End If
            End With
        Next

        ' check the "slop" and "edge" of each edge
        For i = 1 To NE
            If (Abs(Map(Edges(i).e).z - Map(Edges(i).b).z) / edgeLength(i)) > 0.1 Then
                warn = addWarn(warn, "Large slope at edge (" + CStr(Edges(i).b) + ", " + CStr(Edges(i).e) + ")")
            End If
            If (Edges(i).w > 12) Then
                warn = addWarn(warn, "Edge " + CStr(i) + " is too wide")
            ElseIf (Edges(i).w < 8) Then
                warn = addWarn(warn, "Edge " + CStr(i) + " is too narraw")
            End If
        Next

        ' detect duplicate edges
        For i = 1 To NE
            For j = (i + 1) To NE
                If edgeSame(i, j) Then
                    warn = addWarn(warn, "Edges " + CStr(i) + "(" + CStr(Edges(i).b) + ", " + CStr(Edges(i).e) + ")" + " and " + CStr(j) + "(" + CStr(Edges(j).b) + ", " + CStr(Edges(j).e) + ")" + " are the same")
                End If
            Next
        Next

        ' check "multiple blockages in a pipe" and "blockage is not in pipe" and "blockage is close to a node"
        initFlgArray(EdgeFlags, NE, 0)
        For i = 1 To NB
            vL = edgeLength(Blocks(i).e)
            If ((Blocks(i).d < (6 - TOL)) And (Blocks(i).d < vL)) Then
                warn = addWarn(warn, "Blockage " + CStr(i) + " is too close to node " + CStr(Edges(Blocks(i).e).b))
            End If
            If (((vL - Blocks(i).d) < (6 - TOL)) And (Blocks(i).d < vL)) Then
                warn = addWarn(warn, "Blockage " + CStr(i) + " is too close to node " + CStr(Edges(Blocks(i).e).e))
            End If
            If (Blocks(i).d > vL) Then
                warn = addWarn(warn, "Blockage " + CStr(i) + " is not in edge " + CStr(Blocks(i).e))
            End If
            If (EdgeFlags(Blocks(i).e) = 1) Then
                warn = addWarn(warn, "Edge " + CStr(Blocks(i).e) + " has multiple blockages")
            End If
            EdgeFlags(Blocks(i).e) = EdgeFlags(Blocks(i).e) + 1
        Next

        ' test if the map is connected by searching nodes
        initFlgArray(NodeFlags, NN, 10000)
        GetDist(NodeFlags, 1, 0)
        For i = 1 To NN
            If (NodeFlags(i) = 10000) Then
                warn = addWarn(warn, "Map is not connected")
                Exit For
            End If
        Next

        ' return the warnning message
        Return warn
    End Function
    Public Function getTurn(ByVal a As Integer, ByVal b As Integer, ByVal c As Integer) As String
        'Pre:
        '  a, b, c are indices of nodes, robot go through a, b, c sequentially
        'Post:
        '  "L"=Left "R"=Right "F"=Forward "B"=Back "-"=Unhandled_turn
        Dim ang1, ang2, dAng As Double
        Dim dx1, dy1, dx2, dy2 As Double
        dx1 = Map(b).x - Map(a).x
        dy1 = Map(b).y - Map(a).y
        dx2 = Map(c).x - Map(b).x
        dy2 = Map(c).y - Map(b).y
        ang1 = GetAngle(dx1, dy1)
        ang2 = GetAngle(dx2, dy2)
        dAng = (ang2 - ang1 + 2 * PI) Mod (2 * PI)
        If (Abs(dAng - 3 * PI / 2) < TOL) Then
            Return "R"
        ElseIf (Abs(dAng - PI / 2) < TOL) Then
            Return "L"
        ElseIf (Abs(dAng) < TOL) Then
            Return "F"
        ElseIf (Abs(dAng - PI) < TOL) Then
            Return "B"
        Else
            Return "-"
        End If
    End Function
    Public Function GetAngle(ByVal x As Double, ByVal y As Double) As Double
        ' post: return angle in rad between 0 and 2PI
        Dim vNorm As Double
        vNorm = Sqrt(x * x + y * y)
        If (x >= 0) Then
            Return (Asin(y / vNorm) + 2 * PI) Mod (2 * PI)
        Else
            Return (Asin(-y / vNorm) + 3 * PI) Mod (2 * PI)
        End If
    End Function
    ' Private functions for inside the module
    Private Sub GetDist(ByVal Flgs() As Integer, ByVal initN As Integer, ByVal NVal As Integer)
        Dim i As Integer
        Flgs(initN) = NVal
        With Map(initN)
            For i = 1 To .neighCnt
                If (Flgs(.neighbors(i)) > (NVal + 1)) Then
                    GetDist(NodeFlags, .neighbors(i), NVal + 1)
                End If
            Next
        End With
    End Sub
    Private Function GetOneNumber(ByRef sr As StreamReader, ByRef resultcode As Integer) As Double
        ' Pre:
        '   1. Only digits, "E", "e", "." , "+", "-" and space are in stream
        '   2. space can include caridge return
        '   3. no alphabatic characters in the stream
        '   4. there is valid word in the stream
        ' Post:
        '   1. trim the read word from stream
        '   2. resultcode interpretation
        '        -2 -- error: no more data in the file
        '        -1 -- error: string cannot be converted to number
        '         0 -- the obtained double is general and cannot be converted to integer
        '         1 -- the obtained double is exactly 0
        '         2 -- the obtained double can be converted to nonzero positive integer


        Dim NumStr As String
        ' initialization
        NumStr = ""
        While (TmpLine = Nothing)
            If (sr.Peek < 0) Then
                resultcode = -2
                Return 0
            End If
            TmpLine = sr.ReadLine
        End While

        ' read until getting a digit character or "E" or "e" or "." or "+" or "-"
        While (Not IsNumChar(TmpLine.Chars(0)))
            TmpLine = TmpLine.Remove(0, 1)
            While (TmpLine = Nothing)
                If (sr.Peek) < 0 Then
                    resultcode = -2
                    Return 0
                End If
                TmpLine = sr.ReadLine
            End While
        End While

        Try
            ' keep getting characters until encounter another space
            While IsNumChar(TmpLine.Chars(0))
                NumStr = NumStr + TmpLine.Chars(0)
                TmpLine = TmpLine.Remove(0, 1)
                While (TmpLine = Nothing)
                    resultcode = NumType(CDbl(NumStr))
                    Return CDbl(NumStr)
                End While
            End While

            ' convert the string to a number
            resultcode = NumType(CDbl(NumStr))
            Return CDbl(NumStr)
        Catch
            resultcode = -1
            Return 0
        End Try
    End Function
    Private Function IsNumChar(ByVal c As String) As Boolean
        'pre:
        '    c is a one character string
        Return (IsNumeric(c) Or (c = "+") Or (c = "-") Or (c = ".") Or (c = "E") Or (c = "e"))
    End Function
    Private Function NumType(ByVal n As Double) As Integer
        '   Post:
        '         0 -- the obtained double is general and cannot be converted to nonnegative integer
        '         1 -- the obtained double is exactly 0
        '         2 -- the obtained double can be converted to nonzero positive integer
        If ((n = CInt(n)) And (CInt(n) > 0)) Then
            Return 2
        ElseIf (n = CInt(n)) And (CInt(n) = 0) Then
            Return 1
        Else
            Return 0
        End If
    End Function
    Private Function addWarn(ByVal originWarn As String, ByVal toAdd As String) As String
        If originWarn = "" Then
            Return "$" + toAdd
        Else
            Return originWarn + Chr(13) + "  " + toAdd
        End If
    End Function
    Private Function edgeLength(ByVal i As Integer) As Double
        Dim dx, dy As Double
        dx = Map(Edges(i).e).x - Map(Edges(i).b).x
        dy = Map(Edges(i).e).y - Map(Edges(i).b).y
        Return Sqrt(dx * dx + dy * dy)
    End Function
    Private Function edgeLength3D(ByVal i As Integer) As Double
        Dim dx, dy, dz As Double
        dx = Map(Edges(i).e).x - Map(Edges(i).b).x
        dy = Map(Edges(i).e).y - Map(Edges(i).b).y
        dz = Map(Edges(i).e).z - Map(Edges(i).b).z
        Return Sqrt(dx * dx + dy * dy + dz * dz)
    End Function
    Private Function edgeSame(ByVal i As Integer, ByVal j As Integer) As Boolean
        If ((Edges(i).b = Edges(j).b) And (Edges(i).e = Edges(j).e)) Then
            Return True
        ElseIf ((Edges(i).e = Edges(j).b) And (Edges(i).b = Edges(j).e)) Then
            Return True
        End If
        Return False
    End Function
    ' Extra utility functions which is not in MIS/MID
    Public Function NodeToOpen(ByVal iNode As Integer) As Integer
        Dim i As Integer
        For i = 1 To NO
            If iNode = Opens(i) Then
                Return i
            End If
        Next
        Return -1
    End Function
    Public Function NodeToEdge(ByVal i As Integer, ByVal j As Integer) As Integer
        Dim cnt As Integer
        With Map(i)
            For cnt = 1 To .neighCnt
                If (.neighbors(cnt) = j) Then
                    Return .eIndex(cnt)
                End If
            Next
        End With
        Return -1
    End Function
    Public Function FindBlock(ByVal ie As Integer) As Integer
        'Pre:
        '    ie is edge index
        'Post:
        '    1. return the index of blockage which is not cleared
        '    2. if there is no blockage in that edge, return -1
        Dim i As Integer
        For i = 1 To NB
            If ((Blocks(i).e = ie) And (BlockFlags(i) = 0)) Then
                Return i
            End If
        Next
        Return -1
    End Function
    Public Function FindBlockOrigin(ByVal ie As Integer) As Integer
        'Pre:
        '    ie is edge index
        'Post:
        '    1. return the index of blockage does not matter if it is cleared
        '    2. if there is no blockage in that edge, return -1
        Dim i As Integer
        For i = 1 To NB
            If (Blocks(i).e = ie) Then
                Return i
            End If
        Next
        Return -1
    End Function
    Public Sub initFlgArray(ByRef arr() As Integer, ByVal len As Integer, ByVal ele As Integer)
        Dim i As Integer
        For i = 0 To len
            arr(i) = ele
        Next
    End Sub
    Public Sub SavePathFile(ByVal FileName As String)
        ' save the path file in certain format
        ' Create an instance of StreamWriter to write text to a file.
        Dim i As Integer
        Dim sw As StreamWriter = New StreamWriter(FileName)
        ' Add code to the header file
        sw.Write("int PathSize = " + CStr(ActSize - 1) + Chr(59) + Chr(13))
        sw.Write("char * Path = " + Chr(34))
        For i = 3 To ActSize
            sw.Write(CStr(Act(i)))
        Next
        sw.Write(Chr(34) + Chr(59))
        sw.Write(Chr(13))
        ' close the file
        sw.Close()
    End Sub
End Module
Module wSystemComm
    Public Sub UploadFirmware()
        Shell("c:\cygwin\brickos-0.2.6.10.6\batchs\uploadfirm.bat")
    End Sub
    Public Sub UploadJob()
        Shell("c:\cygwin\brickos-0.2.6.10.6\batchs\uploadprog.bat")
    End Sub
    Public Sub UploadCali()
        Shell("c:\cygwin\brickos-0.2.6.10.6\batchs\uploadcali.bat")
    End Sub
End Module
Module wHelp
    Public Sub OpenHelp()
        Shell("c:\cygwin\brickos-0.2.6.10.6\batchs\OpenHelp.bat", AppWinStyle.Hide)
    End Sub
End Module
Module wJobInit
    'The function of this module is implicitly implemented 
    'in Form1 Class when the form is Loaded. This module is
    'now a stub for the possible update in the future.
End Module
Module wFEControl
    ' This module is in higher level of other workstation level,
    ' so it is implemented by the [Form1] class, and it is the 
    ' wrapper of the whole workstation program.
    ' This stub module is here for conceptual integrity.
End Module